'use strict';
//lien données France
let url="https://opensky-network.org/api/states/all?lamin=42.362147&lomin=-4.792165&lamax=51.088424&lomax=8.225285"

function convertStampDate(unixtimestamp){
var months_arr = ['Janvier','Février','Mars','Avril','Mai','Juin','Juillet','Août','Septembre','Octobre','Novembre','Décembre'];
var date = new Date(unixtimestamp*1000);
var year = date.getFullYear();
var month = months_arr[date.getMonth()];
var day = date.getDate();
var hours = date.getHours();
var minutes = "0" + date.getMinutes()
var seconds = "0" + date.getSeconds();
var fulldate = day+' '+month+' '+year+' - '+hours + ':' + minutes.substr(-2) + ':' + seconds.substr(-2);
return fulldate;
}

function affiche_data(dataset) {
	let avions=dataset.states;
	let nbr_avions_tot=0, nbr_av_vol=0, nbr_av_sol=0, nbr_av_fr=0;
	console.log("mise à jour du fichier: "+convertStampDate(dataset.time));
	console.log("nombre d'avions total: "+dataset.states.length);


//calcul des avions au sol
for (let i=0; i<avions.length; i++){
	if (avions[i][8]==true){
		nbr_av_sol++
	}
}
console.log("nombre d'avions au sol: "+nbr_av_sol);

//calcul des avions en vol
for (let i=0; i<avions.length; i++){
	if (avions[i][8]==false){
		nbr_av_vol++;
	}
}
console.log("nombre d'avions en vol: "+nbr_av_vol);

//calcul des avions immatriculés en France parmi les avions référencés
for (let i=0; i<avions.length; i++){
	let avion=avions[i];
	let callsign=avion[1];
	if (callsign[0]=="F"){
	nbr_av_fr++;
}
}
console.log("nombre d'avions immatriculés en France parmi les avions référencés : "+nbr_av_fr);

document.getElementById('MAJ').innerHTML=convertStampDate(dataset.time);
document.getElementById('totalAV').innerHTML=dataset.states.length;
document.getElementById('auSol').innerHTML=nbr_av_sol;
document.getElementById('enVol').innerHTML=nbr_av_vol;
document.getElementById('AVfr').innerHTML=nbr_av_fr;
}

//fonction mise à jour
function mise_a_jour() {
	fetch(url)
		.then(result => result.json())
		.then(data => {

				console.log(data);
				affiche_data(data);
		});
}

